// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10
/*
// Dragons and Arrows from L-System (https://mathematikalpha.de/lindenmayer-system-l-system);
// 3D creation by Droj (31 Mar 2025)

*/
// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

#version 3.7;

#include "G:\3D-Files\Moray_files\POVScn\Galaxy_Files\GX_OPTS_008.INC"
#include "D:\Users\Kolb\Documents\POV-Ray3.7\include\GALAXY.INC"

#include "Dragons_Arrows_I4_obj.inc"
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

global_settings { assumed_gamma 2.2 }

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

#declare Faces_Finish1 = finish { ambient 0.2 diffuse 0.8 specular 0.6 roughness 0.01 }

#declare Prism_Tex2 = texture { pigment { color rgbt <0.8, 0.5, 0.0, 0.7> } finish { Faces_Finish1 } }

#declare Center_Tex =
      texture {
        pigment {
         spiral1 3
           color_map { [ 0.0 color rgbt<1,1,1,0.7>]
                       [ 1.0 color rgb<0.0,0.1,0.3>]}
        scale  0.25
        }
  
        finish { ambient 0.3 diffuse 0.6 brilliance 3.0 specular 0.5 roughness 0.01 }      
      rotate 90*x
      translate <0.5, -0.694209, 0.0>
      }

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

union {
  object { Dragons_Arrows_I4_obj texture { T_Chrome_1A } }

  object { Dragons_Arrows_I4_prm texture { Prism_Tex2 } rotate <-90.0, 0.0, 0.0> }
  
  object { Dragons_Arrows_I4_obj texture { T_Chrome_1A } translate <0.0, 0.0, 8.0> }
  
  object { Dragons_Arrows_I4_prm texture { Prism_Tex2 } rotate <-90.0, 0.0, 0.0> translate <0.0, 0.0, 8.0> }
  
  object { Dragons_Arrows_I4_prm2 texture { Center_Tex } rotate <-90.0, 0.0, 0.0> }
  
  object { Dragons_Arrows_I4_cyl texture { T_Chrome_1A } }
  
    scale 1.0 // 4.0
    rotate <0.0, 45.0, 0.0>
    translate <-0.5, 0.694209, 0.0>
}

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

background { color <0.0,0.0,0.0> }

camera {
    perspective
    location <0, 0, -35> // -100
    sky       <0.0, 1.0, 0.0>  
    up        <0.0, 1.0, 0.0>
    right     x*image_width/image_height 
    angle        54.0
    look_at   <0, 0,  0>
}

light_source {
  <0, 0, 0>
  color rgb <1, 1, 1>
  translate <-15, 50, -100>
}

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

