
#version 3.7;

#include "L-system_2D.inc"
#include "G:\3D-Files\Moray_files\POVScn\Galaxy_Files\GX_OPTS_008.INC"
#include "D:\Users\Kolb\Documents\POV-Ray3.7\include\GALAXY.INC"
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "golds.inc"

global_settings { assumed_gamma 2.2 }



// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

// Dragons and Arrows from L-System (https://mathematikalpha.de/lindenmayer-system-l-system);
// 
// 
#declare GoldenRatio = (1 + sqrt(5))/2;

// Variables
#declare Rules[asc("F")] = "F";
#declare Rules[asc("f")] = "f";

#declare Rules[asc("x")] = "[F+++>F][++<fb|x|-f|a]";
#declare Rules[asc("y")] = "[+F][>F][+f<|y+x]";
#declare Rules[asc("a")] = "[F][++>F][++f---<f|x-y|f|a]";
#declare Rules[asc("b")] = "[-F][>F][<f--af|+b]";

InsertNoChangeFunctions(Functions, "abxy")

InsertLengthFunctions(Functions, GoldenRatio, 0) // > = 1.61803399

#declare Axiom = "af+xf+af+xf+af+xf+af+xf+af+x";

#declare Iterations = 6;
#declare StackSize = 2*Iterations;
#declare L_string = L_Transform(Axiom, Rules, Iterations);

#declare pStart = < -2, 6, 0>;
#declare InitialLength = 4.0;
#declare InitialRadius = 0.05;
#declare InitialHeading = radians(0.0);
#declare InitialTurnAngle = radians(36.0);

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

union {
    L_Draw(
        Functions,
        L_string,
        StackSize,
        pStart,
        InitialLength,
        InitialRadius,
        InitialHeading,
        InitialTurnAngle,
        true,
        true,
        false,
	""
    )
    texture { T_Silver_5C }
    scale 1.0
    
    translate <0.0, 0.20, 0.0>

}

// ********  REFERENCED OBJECTS  *******

#include "Tr_Octahedron0_Frames_obj.inc"
#include "Tr_Octahedron0_Faces_obj.inc"

// ********  OBJECTS  *******

// change texture in Tr_Octahedron0_obj.inc and Tr_Octahedron0_Faces_obj.inc 

object { Tr_Octahedron_Frames
  
  scale 6.5
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
  no_shadow
}

object { Tr_Octahedron_Faces
  
  scale 6.5
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}


// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

background { color <0.0,0.0,0.0> }


camera {
    perspective
    location <0, 0, -25>
    sky       <0.0, 1.0, 0.0>  
    up        <0.0, 1.0, 0.0>
    right     x*image_width/image_height 
    angle        54.0
    look_at   <0, 0,  0>
}

light_source {
  <0, 0, 0>
  color rgb <1, 1, 1>
  translate <-15, 50, -100>
}
/*
// *******  L I G H T S *******
light_source {   // Light003
  <0.0, 0.0, -25.0>
  color rgb <0.5, 0.5, 1.0>
}

light_source {   // Light002
  <0.0, -15.0, 0.0>
  color rgb <0.5, 1.0, 0.5>
}

light_source {   // Light001
  <-15.0, 0.0, 0.0>
  color rgb <1.0, 0.5, 0.5>
}
*/
// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10
