// Truncated Octahedron (8 x Hex + 6 x Sqr) ==> Parallelohedron

#include "metals.inc"

#declare Faces_Finish1 = finish {
   ambient 0.2
   diffuse 0.8
   specular 0.6
   roughness 0.01
}

#declare Faces_Tex3 = texture { pigment { color rgbf <1,0.5,0.5,0.7> } finish { Faces_Finish1 } }
#declare Faces_Tex1 = texture { pigment { color rgbf <1,1,0.5,0.7> } finish { Faces_Finish1 } }
#declare Faces_Tex4 = texture { pigment { color rgbt <0.5,0.5,1,0.5> } finish { Faces_Finish1 } }
#declare Faces_Tex2 = texture { pigment { color rgbf <0.5,1,0.5,0.7> } finish { Faces_Finish1 } }
#declare Faces_Tex5 = texture { pigment { color rgbf <0.5,1,1,0.7> } finish { Faces_Finish1 } }
#declare Faces_Tex6 = texture { pigment { color rgbt <0.5, 0.1, 0.5, 0.7> } finish { Faces_Finish1 } }

#declare a = 0.5;

// right
#declare Sqr_Frame1_Faces =
union {
triangle { <1,  0, -a>, <1, -a,  0>, <1,  a,  0> }
triangle { <1,  0,  a>, <1, -a,  0>, <1,  a,  0> }
}

// left
#declare Sqr_Frame2_Faces =
union { 
triangle { <-1,  0,  a>, <-1, -a,  0>, <-1,  a,  0>  }
triangle { <-1,  0, -a>, <-1, -a,  0>, <-1,  a,  0>  }
}

//front
#declare Sqr_Frame3_Faces =
union { 
triangle { <0,  a, -1>, <-a,  0, -1>, <a,  0, -1> }
triangle { <0, -a, -1>, <-a,  0, -1>, <a,  0, -1>  }
}

//back
#declare Sqr_Frame4_Faces =
union { 
triangle { <0, -a,  1>, <-a,  0,  1>, <a,  0,  1> }
triangle { <0,  a,  1>, <-a,  0,  1>, <a,  0,  1> }
}

//top
#declare Sqr_Frame5_Faces =
union { 
triangle { <a,  1,  0>, <0,  1,  a>, <0,  1, -a> }
triangle { <-a,  1,  0>, <0,  1,  a>, <0,  1, -a> }
}

#declare Sqr_Frame6_Faces =
union { 
triangle { <-a, -1,  0>, <0, -1,  a>, <0, -1, -a> }
triangle { <a, -1,  0>, <0, -1,  a>, <0, -1, -a> }
}


#declare Hex_Frame1_Faces =
union { 
triangle { <0, -1, a>, <0, -a, 1>, <-a, -1, 0> }
triangle { <-a,  0, 1>, <0, -a, 1>, <-a, -1, 0> }
triangle { <-1,  0, a>, <-a,  0, 1>, <-1, -a,  0> }
triangle {<-a, -1, 0>, <-a,  0, 1>, <-1, -a,  0> }
}

#declare Hex_Frame2_Faces =
union { 
triangle { <-1,  0, a>, <-a,  0, 1>, <-1,  a,  0> }
triangle { <0,  a, 1>, <-a,  0, 1>, <-1,  a,  0> }
triangle { <0,  1, a>, <0,  a, 1>, <-a,  1,  0> }
triangle { <-1,  a,  0>, <0,  a, 1>, <-a,  1,  0> }
}

#declare Hex_Frame3_Faces =
union {  
triangle { <0,  1, a>, <0,  a, 1>, <a,  1,  0> }
triangle { <0,  a, 1>, <a,  1,  0>, <1,  a,  0> }
triangle { <1,  0, a>, <a,  0, 1>, <1,  a,  0> }
triangle { <a,  0, 1>, <1,  a,  0>, <0,  a, 1> }
}

#declare Hex_Frame4_Faces =
union { 
triangle { <1,  0, a>, <1, -a,  0>, <a,  0, 1> }
triangle { <a, -1,  0>, <1, -a,  0>, <a,  0, 1> }
triangle { <0, -1, a>, <a, -1,  0>, <0, -a, 1> }
triangle { <a,  0, 1>, <a, -1,  0>, <0, -a, 1> }
}

#declare Hex_Frame5_Faces =
union {  
triangle { <0, -1, -a>, <0, -a, -1>, <-a, -1, 0> }
triangle { <-a,  0, -1>, <0, -a, -1>, <-a, -1, 0> }
triangle { <-1,  0, -a>, <-a,  0, -1>, <-1, -a,  0> }
triangle {<-a, -1, 0>, <-a,  0, -1>, <-1, -a,  0> }
}

#declare Hex_Frame6_Faces =
union {  
triangle { <-1,  0, -a>, <-a,  0, -1>, <-1,  a,  0> }
triangle { <0,  a, -1>, <-a,  0, -1>, <-1,  a,  0> }
triangle { <0,  1, -a>, <0,  a, -1>, <-a,  1,  0> }
triangle { <-1,  a,  0>, <0,  a, -1>, <-a,  1,  0> }
}

#declare Hex_Frame7_Faces =
union { 
triangle { <0,  1, -a>, <0,  a, -1>, <a,  1,  0> }
triangle { <0,  a, -1>, <a,  1,  0>, <1,  a,  0> }
triangle { <1,  0, -a>, <a,  0, -1>, <1,  a,  0> }
triangle { <a,  0, -1>, <1,  a,  0>, <0,  a, -1> }
}

#declare Hex_Frame8_Faces =
union { 
triangle { <1,  0, -a>, <1, -a,  0>, <a,  0, -1> }
triangle { <a, -1,  0>, <1, -a,  0>, <a,  0, -1> }
triangle { <0, -1, -a>, <a, -1,  0>, <0, -a, -1> }
triangle { <a,  0, -1>, <a, -1,  0>, <0, -a, -1> }
}

#declare Tr_Octahedron_Faces =
union {
object { Sqr_Frame1_Faces texture {Faces_Tex4} }
object { Sqr_Frame2_Faces texture {Faces_Tex4} }
object { Sqr_Frame3_Faces texture {Faces_Tex4} }
object { Sqr_Frame4_Faces texture {Faces_Tex4} }
object { Sqr_Frame5_Faces texture {Faces_Tex4} }
object { Sqr_Frame6_Faces texture {Faces_Tex4} }

object { Hex_Frame1_Faces texture {Faces_Tex6} }
object { Hex_Frame2_Faces texture {Faces_Tex6} }
object { Hex_Frame3_Faces texture {Faces_Tex6} }
object { Hex_Frame4_Faces texture {Faces_Tex6} }
object { Hex_Frame5_Faces texture {Faces_Tex6} }
object { Hex_Frame6_Faces texture {Faces_Tex6} }
object { Hex_Frame7_Faces texture {Faces_Tex6} }
object { Hex_Frame8_Faces texture {Faces_Tex6} }

}
