// Truncated Octahedron (8 x Hex + 6 x Sqr) ==> Parallelohedron

#include "metals.inc"

#declare a = 0.5;
#declare SR = 0.025;
#declare CR = 0.015;

#declare Sqr_Frame1 =
union {
sphere { <1,  0, -a>, SR }
cone   { <1,  0, -a>, CR <1, -a,  0>, CR }
sphere { <1, -a,  0>, SR }
cone   { <1, -a,  0>, CR <1,  0,  a>, CR }
sphere { <1,  0,  a>, SR }
cone   { <1,  0,  a>, CR <1,  a,  0>, CR }
sphere { <1,  a,  0>, SR }
cone   { <1,  a,  0>, CR <1,  0, -a>, CR }
}

#declare Sqr_Frame2 =
union { 
sphere { <-1, -a,  0>, SR }
cone   { <-1, -a,  0>, CR <-1,  0,  a>, CR }
sphere { <-1,  0,  a>, SR }
cone   { <-1,  0,  a>, CR <-1,  a,  0>, CR }
sphere { <-1,  a,  0>, SR }
cone   { <-1,  a,  0>, CR <-1,  0, -a>, CR }
sphere { <-1,  0, -a>, SR }
cone   { <-1,  0, -a>, CR <-1, -a,  0>, CR }
}

#declare Sqr_Frame3 =
union { 
sphere { <0,  a, -1>, SR }
cone   { <0,  a, -1>, CR <-a,  0, -1>, CR }
sphere { <-a,  0, -1>, SR }
cone   { <-a,  0, -1>, CR <0, -a, -1>, CR }
sphere { <0, -a, -1>, SR }
cone   { <0, -a, -1>, CR <a,  0, -1>, CR }
sphere { <a,  0, -1>, SR }
cone   { <a,  0, -1>, CR <0,  a, -1>, CR }
}

#declare Sqr_Frame4 =
union { 
sphere { <-a,  0,  1>, SR }
cone   { <-a,  0,  1>, CR <0, -a,  1>, CR } 
sphere { <0, -a,  1>, SR }
cone   { <0, -a,  1>, CR <a,  0,  1>, CR }
sphere { <a,  0,  1>, SR }
cone   { <a,  0,  1>, CR <0,  a,  1>, CR }
sphere { <0,  a,  1>, SR }
cone   { <0,  a,  1>, CR <-a,  0,  1>, CR }
}

#declare Sqr_Frame5 =
union { 
sphere { <a,  1,  0>, SR }
cone   { <a,  1,  0>, CR <0,  1,  a>, CR }
sphere { <0,  1,  a>, SR }
cone   { <0,  1,  a>, CR <-a,  1,  0>, CR }
sphere { <-a,  1,  0>, SR }
cone   { <-a,  1,  0>, CR <0,  1, -a>, CR }
sphere { <0,  1, -a>, SR }
cone   { <0,  1, -a>, CR <a,  1,  0>, CR }
}

#declare Sqr_Frame6 =
union { 
sphere { <0, -1,  a>, SR }
cone   { <0, -1,  a>, CR <-a, -1,  0>, CR }
sphere { <-a, -1,  0>, SR }
cone   { <-a, -1,  0>, CR <0, -1, -a>, CR }
sphere { <0, -1, -a>, SR }
cone   { <0, -1, -a>, CR <a, -1,  0>, CR }
sphere { <a, -1,  0>, SR }
cone   { <a, -1,  0>, CR <0, -1,  a>, CR }
}


#declare Hex_Frame1 =
union { 
sphere { <-a,  0,  1>, SR }
//cone   { <-a,  0,  1>, CR <0, -a,  1>, CR } 
sphere { <0, -a,  1>, SR }
cone   { <0, -a,  1>, CR <0, -1,  a>, CR }
sphere { <0, -1,  a>, SR }
//cone   { <0, -1,  a>, CR <-a, -1,  0>, CR }
sphere { <-a, -1,  0>, SR }
cone   { <-a, -1,  0>, CR <-1, -a,  0>, CR }
sphere { <-1, -a,  0>, SR }
//cone   { <-1, -a,  0>, CR <-1,  0,  a>, CR }
sphere { <-1,  0,  a>, SR }
cone   { <-1,  0,  a>, CR <-a,  0,  1>, CR }

}

#declare Hex_Frame2 =
union { 
sphere { <-a,  0,  1>, SR }
cone   { <-a,  0,  1>, CR <-1,  0,  a>, CR }
sphere { <-1,  0,  a>, SR }
//cone   { <-1,  0,  a>, CR <-1,  a,  0>, CR }
sphere { <-1,  a,  0>, SR }
cone   { <-1,  a,  0>, CR <-a,  1,  0>, CR }
sphere { <-a,  1,  0>, SR }
//cone   { <-a,  1,  0>, CR <0,  1,  a>, CR } 
sphere { <0,  1,  a>, SR }
cone   { <0,  1,  a>, CR <0,  a,  1>, CR } 
sphere { <0,  a,  1>, SR }
//cone   { <0,  a,  1>, CR <-a,  0,  1>, CR }
}

#declare Hex_Frame3 =
union {  
sphere { <0,  a,  1>, SR }
cone   { <0,  a,  1>, CR <0,  1,  a>, CR } 
sphere { <0,  1,  a>, SR }
//cone   { <0,  1,  a>, CR <a,  1,  0>, CR } 
sphere { <a,  1,  0>, SR }
cone   { <a,  1,  0>, CR <1,  a,  0>, CR } 
sphere { <1,  a,  0>, SR }
//cone   { <1,  a,  0>, CR <1,  0,  a>, CR } 
sphere { <1,  0,  a>, SR }
cone   { <1,  0,  a>, CR <a,  0,  1>, CR } 
sphere { <a,  0,  1>, SR }
//cone   { <a,  0,  1>, CR <0,  a,  1>, CR }
}

#declare Hex_Frame4 =
union {  
sphere { <a,  0,  1>, SR }
cone   { <a,  0,  1>, CR <1,  0,  a>, CR } 
sphere { <1,  0,  a>, SR }
//cone   { <1,  0,  a>, CR <1, -a,  0>, CR } 
sphere { <1, -a,  0>, SR }
cone   { <1, -a,  0>, CR <a, -1,  0>, CR } 
sphere { <a, -1,  0>, SR }
//cone   { <a, -1,  0>, CR <0, -1,  a>, CR } 
sphere { <0, -1,  a>, SR }
cone   { <0, -1,  a>, CR <0, -a,  1>, CR } 
sphere { <0, -a,  1>, SR }
//cone   { <0, -a,  1>, CR <a,  0,  1>, CR }
}

#declare Hex_Frame5 =
union {  
sphere { <a,  0, -1>, SR }
cone   { <a,  0, -1>, CR <0, -a, -1>, CR } 
sphere { <0, -a, -1>, SR }
cone   { <0, -a, -1>, CR <0, -1, -a>, CR } 
sphere { <0, -1, -a>, SR }
cone   { <0, -1, -a>, CR <-a, -1,  0>, CR }
sphere { <-a, -1,  0>, SR }
cone   { <-a, -1,  0>, CR <-1, -a,  0>, CR }
sphere { <-1, -a,  0>, SR }
cone   { <-1, -a,  0>, CR <-1,  0, -a>, CR }
sphere { <-1,  0, -a>, SR }
cone   { <-1,  0, -a>, CR <-a,  0, -1>, CR }
}

#declare Hex_Frame6 =
union {  
sphere { <-a,  0, -1>, SR }
//cone   { <-a,  0, -1>, CR <-1,  0 -a>, CR }
sphere { <-1,  0 -a>, SR }
//cone   { <-1,  0 -a>, CR <-1,  a,  0>, CR }
sphere { <-1,  a,  0>, SR }
cone   { <-1,  a,  0>, CR <-a,  1,  0>, CR }
sphere { <-a,  1,  0>, SR }
cone   { <-a,  1,  0>, CR <0,  1, -a>, CR } 
sphere { <0,  1, -a>, SR }
cone   { <0,  1, -a>, CR <0,  a, -1>, CR } 
sphere { <0,  a, -1>, SR }
cone   { <0,  a, -1>, CR <-a,  0, -1>, CR }
}

#declare Hex_Frame7 =
union { 
sphere { <0,  a, -1>, SR }
cone   { <0,  a, -1>, CR <0,  1, -a>, CR } 
sphere { <0,  1, -a>, SR }
cone   { <0,  1, -a>, CR <a,  1,  0>, CR } 
sphere { <a,  1,  0>, SR }
cone   { <a,  1,  0>, CR <1,  a,  0>, CR } 
sphere { <1,  a,  0>, SR }
cone   { <1,  a,  0>, CR <1,  0, -a>, CR }
sphere { <1,  0, -a>, SR }
cone   { <1,  0, -a>, CR <a,  0, -1>, CR } 
sphere { <a,  0, -1>, SR }
cone   { <a,  0, -1>, CR <0,  a, -1>, CR }
}

#declare Hex_Frame8 =
union { 
sphere { <a,  0, -1>, SR }
cone   { <a,  0, -1>, CR <1,  0, -a>, CR } 
sphere { <1,  0, -a>, SR }
cone   { <1,  0, -a>, CR <1, -a,  0>, CR } 
sphere { <1, -a,  0>, SR }
cone   { <1, -a,  0>, CR <a, -1,  0>, CR } 
sphere { <a, -1,  0>, SR }
cone   { <a, -1,  0>, CR <0, -1, -a>, CR }
sphere { <0, -1, -a>, SR }
cone   { <0, -1, -a>, CR <0, -a, -1>, CR } 
sphere { <0, -a, -1>, SR }
cone   { <0, -a, -1>, CR <a,  0, -1>, CR }
}

#declare Tr_Octahedron_Frames =
union {
object { Sqr_Frame1 texture {T_Chrome_1A} }
object { Sqr_Frame2 texture {T_Chrome_1A} }
object { Sqr_Frame3 texture {T_Chrome_1A} }
object { Sqr_Frame4 texture {T_Chrome_1A} }
object { Sqr_Frame5 texture {T_Chrome_1A} }
object { Sqr_Frame6 texture {T_Chrome_1A} }
//T_Chrome_1A
object { Hex_Frame1 texture {T_Chrome_1A} }
object { Hex_Frame2 texture {T_Chrome_1A} }
object { Hex_Frame3 texture {T_Chrome_1A} }
object { Hex_Frame4 texture {T_Chrome_1A} }
object { Hex_Frame5 texture {T_Chrome_1A} }
object { Hex_Frame6 texture {T_Chrome_1A} }
object { Hex_Frame7 texture {T_Chrome_1A} }
object { Hex_Frame8 texture {T_Chrome_1A} }
}
