// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10
/*


*/
// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

#version 3.7;

#include "Sierpinski_3_obj.inc"
#include "Sierpinski_3_prm.inc"
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

global_settings { assumed_gamma 2.2 }


// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

// Quadratic Sierpinski curve from https://en.wikipedia.org/wiki/Sierpinski_curve;
// filled with a prism by Droj (30 Mar 2025)


#declare Faces_Finish1 = finish { ambient 0.2 diffuse 0.8 specular 0.6 roughness 0.01 }

#declare Prism_Tex2 = texture { pigment { color rgbt <0.8, 0.5, 0.0, 0.7> } finish { Faces_Finish1 } }

#declare Prism_Tex4 = texture { pigment { color rgbt <0.0, 0.1, 0.5, 0.7> } finish { Faces_Finish1 } }  

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

union {
    object { Sierpinski_3_obj texture { Spun_Brass } }
    object { Sierpinski_3_prm texture { Prism_Tex2 } rotate -90*x }
    
    scale 1.0
    
    translate <0.0, 0.0, 0.0>

}

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10

background { color <0.0,0.0,0.0> }


camera {
    perspective
    location <0, 0, -100>
    sky       <0.0, 1.0, 0.0>  
    up        <0.0, 1.0, 0.0>
    right     x*image_width/image_height 
    angle        54.0
    look_at   <0, 0,  0>
}

light_source {
  <0, 0, 0>
  color rgb <1, 1, 1>
  translate <-15, 50, -100>
}

// ===== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ======= 8 ======= 9 ======= 10 


/*
#include "Coord_S.inc"
object {
        Coord_System  
        translate <0, 0, 0>
        rotate 0*y
        }
*/
